package fr.stelal.demoscan;

import java.util.List;

import android.annotation.TargetApi;
import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.Camera;
import android.hardware.Camera.PictureCallback;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.RGBLuminanceSource;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;

import fr.stelal.demoscan.util.SystemUiHider;

/**
 * An example full-screen activity that shows and hides the system UI (i.e.
 * status bar and navigation/system bar) with user interaction.
 *
 * @see SystemUiHider
 */
public class FullscreenActivity extends Activity
{
	private SurfaceView preview=null;
	private SurfaceHolder previewHolder=null;
	private Camera camera=null;
	private boolean inPreview=false;
	private boolean cameraConfigured=false;
	
	private int counter = 0;
	
	Handler handler = new Handler();
	private final Runnable doStuff = new Runnable(){
	    public void run(){
	        try {
	            //do you thing here
	        	int step = 5;
	        	counter += step;
	        	counter = counter % 100;
	        	TextView tv = (TextView)findViewById(R.id.fullscreen_content);
	        	if (tv!=null)
	        		tv.setText(Integer.valueOf(counter).toString());
	        	
	        	//live compute !
	        	if (inPreview)
	        		takePicture();

	        	//loop by posting itself again
	            handler.postDelayed(this, step * 1000);    
	        }
	        catch (Exception e) {
	            e.printStackTrace();
	        }   
	    }
	};
	
    private static final boolean AUTO_HIDE = true;
    private static final int AUTO_HIDE_DELAY_MILLIS = 3000;
    private static final boolean TOGGLE_ON_CLICK = true;
    private static final int HIDER_FLAGS = SystemUiHider.FLAG_HIDE_NAVIGATION;

    /**
     * The instance of the {@link SystemUiHider} for this activity.
     */
    private SystemUiHider mSystemUiHider;

    @SuppressWarnings("deprecation")
	@Override
    protected void onCreate(Bundle savedInstanceState) 
    {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_fullscreen);

        final View controlsView = findViewById(R.id.fullscreen_content_controls);
        final View contentView = findViewById(R.id.fullscreen_content);

        // Set up an instance of SystemUiHider to control the system UI for
        // this activity.
        mSystemUiHider = SystemUiHider.getInstance(this, contentView, HIDER_FLAGS);
        mSystemUiHider.setup();
        mSystemUiHider
                .setOnVisibilityChangeListener(new SystemUiHider.OnVisibilityChangeListener() {
                    // Cached values.
                    int mControlsHeight;
                    int mShortAnimTime;

                    @Override
                    @TargetApi(Build.VERSION_CODES.HONEYCOMB_MR2)
                    public void onVisibilityChange(boolean visible) {
                        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB_MR2) {
                            // If the ViewPropertyAnimator API is available
                            // (Honeycomb MR2 and later), use it to animate the
                            // in-layout UI controls at the bottom of the
                            // screen.
                            if (mControlsHeight == 0) {
                                mControlsHeight = controlsView.getHeight();
                            }
                            if (mShortAnimTime == 0) {
                                mShortAnimTime = getResources().getInteger(
                                        android.R.integer.config_shortAnimTime);
                            }
                            controlsView.animate()
                                    .translationY(visible ? 0 : mControlsHeight)
                                    .setDuration(mShortAnimTime);
                        } else {
                            // If the ViewPropertyAnimator APIs aren't
                            // available, simply show or hide the in-layout UI
                            // controls.
                            controlsView.setVisibility(visible ? View.VISIBLE : View.GONE);
                        }

                        if (visible && AUTO_HIDE) {
                            // Schedule a hide().
                            delayedHide(AUTO_HIDE_DELAY_MILLIS);
                        }
                    }
                });

        // Set up the user interaction to manually show or hide the system UI.
        contentView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                if (TOGGLE_ON_CLICK) {
                    mSystemUiHider.toggle();
                } else {
                    mSystemUiHider.show();
                }
            }
        });

        // Upon interacting with UI controls, delay any scheduled hide()
        // operations to prevent the jarring behavior of controls going away
        // while interacting with the UI.
        findViewById(R.id.swap_button).setOnTouchListener(mDelayHideTouchListener);
        
        findViewById(R.id.swap_button).setOnClickListener(mSwapClickListener);
        

        // CAMERA 
        
        preview=(SurfaceView)findViewById(R.id.preview);
        previewHolder=preview.getHolder();
        previewHolder.addCallback(surfaceCallback);
        previewHolder.setType(SurfaceHolder.SURFACE_TYPE_PUSH_BUFFERS);        

    }
   
    
    @Override
    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);

        // Trigger the initial hide() shortly after the activity has been
        // created, to briefly hint to the user that UI controls
        // are available.
        delayedHide(100);
    }

    
    @Override
	protected void onStop() {
		// TODO Auto-generated method stub
		super.onStop();
	}


	@Override
	protected void onDestroy() {
    	stopPreview();
		super.onDestroy();
	}

	@Override
	public void onResume() {
		super.onResume();
		camera = Camera.open();
		startPreview();
		handler.post(doStuff);
	}

	@Override
	public void onPause() {
		handler.removeCallbacks(doStuff);
		stopPreview();
		super.onPause();
	}

    /**
     * Touch listener to use for in-layout UI controls to delay hiding the
     * system UI. This is to prevent the jarring behavior of controls going away
     * while interacting with activity UI.
     */
    View.OnTouchListener mDelayHideTouchListener = new View.OnTouchListener() {
        @Override
        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (AUTO_HIDE) {
                delayedHide(AUTO_HIDE_DELAY_MILLIS);
            }
            return false;
        }
    };

    View.OnClickListener mSwapClickListener = new View.OnClickListener() {
		@Override
		public void onClick(View arg0) {
			takePicture();
		}
    };

    Handler mHideHandler = new Handler();
    Runnable mHideRunnable = new Runnable() {
        @Override
        public void run() {
            mSystemUiHider.hide();
        }
    };

    /**
     * Schedules a call to hide() in [delay] milliseconds, canceling any
     * previously scheduled calls.
     */
    private void delayedHide(int delayMillis) {
        mHideHandler.removeCallbacks(mHideRunnable);
        mHideHandler.postDelayed(mHideRunnable, delayMillis);
    }
    
    //----------------------------------

	private Camera.Size getBestPreviewSize(int width, int height, Camera.Parameters parameters) 
	{
		Camera.Size result = null;

		for (Camera.Size size : parameters.getSupportedPreviewSizes()) 
		{
			if (size.width <= width && size.height <= height) 
			{
				if (result == null) 
				{
					result = size;
				} 
				else 
				{
					int resultArea = result.width * result.height;
					int newArea = size.width * size.height;

					if (newArea > resultArea) 
					{
						result = size;
					}
				}
			}
		}

		return (result);
	}
	
	
    private void initPreview(int width, int height) {
        if (camera!=null && previewHolder.getSurface()!=null) {
          try {
            camera.setPreviewDisplay(previewHolder);
            camera.setDisplayOrientation(90);//++
          }
          catch (Throwable t) {
            Log.e("PreviewDemo-surfaceCallback",
                  "Exception in setPreviewDisplay()", t);
            Toast
              .makeText(this, t.getMessage(), Toast.LENGTH_LONG)
              .show();
          }

          if (!cameraConfigured) {
            Camera.Parameters parameters=camera.getParameters();
            Camera.Size size=getBestPreviewSize(width, height, parameters);
             
            List<String> focusModes = parameters.getSupportedFocusModes();
            if (focusModes.contains(Camera.Parameters.FOCUS_MODE_AUTO))
            {
                parameters.setFocusMode(Camera.Parameters.FOCUS_MODE_AUTO);
            }
            
            if (size!=null) {
              parameters.setPreviewSize(size.width, size.height);
              camera.setParameters(parameters);
              cameraConfigured=true;
            }
          }
        }
        
      }
    
    
	public void takePicture() {
	    Log.i("Camera View: ", "Take Picture");
	        camera.takePicture(null, null, new PictureCallback() {
	            @Override
	            public void onPictureTaken(byte[] data, Camera camera) {
	            	
	            	 Bitmap bMap = BitmapFactory.decodeByteArray(data, 0, data.length);
	            	
	            	 ImageView tv1 = (ImageView)findViewById(R.id.imageView);
	            	 tv1.setImageBitmap(bMap);
	            	 
	            	 //analysis...
	            	 //Bitmap bMap = BitmapFactory.decodeStream(new FileInputStream(file));
	            	 //LuminanceSource source = new RGBLuminanceSource(bMap);
	            	 
	            	 int[] intArray = new int[bMap.getWidth()*bMap.getHeight()];  
	            	//copy pixel data from the Bitmap into the 'intArray' array  
	            	bMap.getPixels(intArray, 0, bMap.getWidth(), 0, 0, bMap.getWidth(), bMap.getHeight());  

	            	LuminanceSource source = new RGBLuminanceSource(bMap.getWidth(), bMap.getHeight(),intArray);

	            	 BinaryBitmap bitmap = new BinaryBitmap(new HybridBinarizer(source));
	            	 Reader reader = new MultiFormatReader();

	            	 Result result = null;
	            	 try {
						result = reader.decode(bitmap);
						
					} catch (Exception e) {
						Toast.makeText(
		            			FullscreenActivity.this, 
		            			e.getMessage(),
		            			Toast.LENGTH_LONG).show();
						e.printStackTrace();
					}
	            	 
	            	if (result == null)
	            	{
		            	Toast.makeText(
		            			FullscreenActivity.this, 
		            			"Decode que dalle",
		            			Toast.LENGTH_LONG).show();
	            	}
	            	else
	            	{
		            	Toast.makeText(
		            			FullscreenActivity.this, 
		            			result.getText(),
		            			Toast.LENGTH_LONG).show();
	            	}

	            	//takePicture stops preview... so :
	    	        camera.startPreview();
	            }
	        });
	 }
    
    
      private void startPreview() {
        if (cameraConfigured && camera!=null && !inPreview) {
          camera.startPreview();
          inPreview=true;
        }
      }
      
      private void stopPreview() {
    	    if (camera!=null)
      	    {
      	      if (inPreview) {
      	        camera.stopPreview();
      	      }
              camera.release();
      	      camera=null;
      	    }
  	      inPreview=false;      
    }

    SurfaceHolder.Callback surfaceCallback=new SurfaceHolder.Callback() {
        public void surfaceCreated(SurfaceHolder holder) {
          // no-op -- wait until surfaceChanged()
        }
        
        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
          initPreview(width, height);
          startPreview();
        }
        
        public void surfaceDestroyed(SurfaceHolder holder) {
          // no-op
        }
      };
    
    
}

